#include "User_api.h"


void init_python_config() {
        Py_SetPath(L"C:\\Users\\main_dir_name\\anaconda3\\envs\\aaa\\Lib;C:\\Users\\main_dir_name\\anaconda3\\envs\\aaa\\Lib\\site-packages;C:\\Users\\main_dir_name\\anaconda3\\envs\\aaa\\DLLs;C:\\Users\\main_dir_name\\Documents\\or_e2e\\NN_python");
    Py_Initialize();
        wchar_t* program_name = Py_GetProgramName();
    wchar_t* sys_path = Py_GetPath();
    wchar_t* sys_prefix = Py_GetPrefix();
    wchar_t* sys_exec_prefix = Py_GetExecPrefix();
    wchar_t* sys_executable = Py_GetProgramFullPath();
    wstring program_name_w(program_name);
    wstring sys_path_w(sys_path);
    wstring sys_prefix_w(sys_prefix);
    wstring sys_exec_prefix_w(sys_exec_prefix);
    wstring sys_executable_w(sys_executable);
    string program_name_str(program_name_w.begin(), program_name_w.end());
    string sys_path_str(sys_path_w.begin(), sys_path_w.end());
    string sys_prefix_str(sys_prefix_w.begin(), sys_prefix_w.end());
    string sys_exec_prefix_str(sys_exec_prefix_w.begin(), sys_exec_prefix_w.end());
    string sys_executable_str(sys_executable_w.begin(), sys_executable_w.end());
                        }


User_api::User_api(const char* module_name, NN_data* nn_data, User_parameter* user_parameter, NN_parameter* nn_parameter, app1_gradient* gradient) {
    this->nn_data = nn_data;
    this->user_parameter = user_parameter;
    this->nn_parameter = nn_parameter;
    this->gradient = gradient;
    init_python_config();
    PyObject* pName = PyUnicode_DecodeFSDefault(module_name);
    this->nn_module = PyImport_Import(pName);
    Py_XDECREF(pName);
    if (this->nn_module == NULL) cout << "      User_api:: PYMODULE IMPORT ERROR" << module_name << endl;
    else {
        this->func_load_dataset = PyObject_GetAttrString(this->nn_module, "load_dataset");
        if (!this->func_load_dataset || !PyCallable_Check(this->func_load_dataset)) cout << "PYFUNCTION CALL ERROR" << endl;
        this->func_set_nnparameters = PyObject_GetAttrString(this->nn_module, "set_nnparameter");
        if (!this->func_set_nnparameters || !PyCallable_Check(this->func_set_nnparameters)) cout << "PYFUNCTION CALL ERROR" << endl;
        this->func_update_nndata = PyObject_GetAttrString(this->nn_module, "update_nndata");
        if (!this->func_update_nndata || !PyCallable_Check(this->func_update_nndata)) cout << "PYFUNCTION CALL ERROR" << endl;
        this->func_backpropagation = PyObject_GetAttrString(this->nn_module, "backpropagation");
        if (!this->func_backpropagation || !PyCallable_Check(this->func_backpropagation)) cout << "PYFUNCTION CALL ERROR" << endl;
    }
}


void User_api::clear() {
    Py_DECREF(this->nn_module);
    Py_DECREF(this->func_load_dataset);
    Py_DECREF(this->func_set_nnparameters);
    Py_DECREF(this->func_update_nndata);
    Py_DECREF(this->func_backpropagation);
    if (Py_FinalizeEx() < 0) cout << "      User_api:: PYFINALIZE ERROR" << endl;
}

void User_api::set_userparameters(int n_internal_test_case, int n_rank, double th,  double beta, double lambda, double xi) {
    this->user_parameter->n_internal_test_case = n_internal_test_case;
    this->user_parameter->n_rank = n_rank;
    this->user_parameter->th = th;
    this->user_parameter->beta = beta;
    this->user_parameter->lambda = lambda;
    this->user_parameter->xi = xi;
}


void User_api::set_userparameter(string param_name, int param) {
    if (param_name == "n_sample") this->user_parameter->n_sample = param;
    else if (param_name == "n_rank") this->user_parameter->n_rank = param;
        else {
        cout << "      User_api:: USER-PARAMETER ERROR - please check the name of the parameter." << endl;
        return;
    }
    cout << "      User_api:: CHANGE USER-PARAMETER! (" << param_name << ")" << endl;
}


void User_api::set_userparameter(string param_name, double singlevalue, ...) {
    if (param_name == "th") this->user_parameter->th = singlevalue;
    else if (param_name == "mb") this->user_parameter->mb = singlevalue;
    else if (param_name == "Mb") this->user_parameter->Mb = singlevalue;
    else if (param_name == "M") this->user_parameter->M = singlevalue;
    else if (param_name == "beta") this->user_parameter->beta = singlevalue;
    else if (param_name == "lambda") this->user_parameter->lambda = singlevalue;
    else if (param_name == "lambda_decay") this->user_parameter->lambda = this->user_parameter->lambda*singlevalue;
    else if (param_name == "xi") this->user_parameter->xi = singlevalue;
    else if (param_name == "context") {
        va_list context_list;
        va_start(context_list, param_name);
        double arg = 0.;
        for (int j = 0; j < n_label; j++)
            for (int i = 0; i < this->user_parameter->n_rank; i++) {
                arg = va_arg(context_list, double);
                this->user_parameter->context[j][i] = arg;
            }
    }
    else {
        cout << "      User_api:: USER-PARAMETER ERROR - please check the name of the parameter." << endl;
        return;
    }
    cout << "      User_api:: CHANGE USER-PARAMETER! (" << param_name << ")" << endl;
}

int User_api::get_userparameter_int(string param_name) {
    if (param_name == "n_sample") return this->user_parameter->n_sample;
    else if (param_name == "n_internal_test_case") return this->user_parameter->n_internal_test_case;
    else if (param_name == "n_rank") return this->user_parameter->n_rank;
    else {
        cout << "      User_api:: USER-PARAMETER ERROR - please check the name of the parameter." << endl;
        return -1;
    }
}

double User_api::get_userparameter_double(string param_name) {
    if (param_name == "th") return this->user_parameter->th;
    else if (param_name == "mb") return this->user_parameter->mb;
    else if (param_name == "Mb") return this->user_parameter->Mb;
    else if (param_name == "M") return this->user_parameter->M;
    else if (param_name == "beta") return this->user_parameter->beta;
    else if (param_name == "lambda") return this->user_parameter->lambda;
    else if (param_name == "xi") return this->user_parameter->xi;
    else {
        cout << "      User_api:: USER-PARAMETER ERROR - please check the name of the parameter." << endl;
        return -1.;
    }
}

void User_api::set_nnparameters(double dropout, double alpha, double lr, double weight_decay) {
    if (this->nn_parameter->dropout != dropout || this->nn_parameter->alpha != alpha || this->nn_parameter->lr != lr || this->nn_parameter->weight_decay != weight_decay) {
        this->nn_parameter->dropout = dropout;
        this->nn_parameter->alpha = alpha;
        this->nn_parameter->lr = lr;
        this->nn_parameter->weight_decay = weight_decay;
        cout << "      User_api:: START NN PARAMETER SETTING!" << endl;
        printf("%lf\t%lf\n", lr, weight_decay);
        this->call_func<double>("func_set_nnparameters", n_label, NULL, dropout, alpha, lr, weight_decay);
        cout << "      User_api:: COMPLETE NN PARAMETER SETTING!" << endl;
    }
}

void User_api::set_nnparameter(string param_name, double singlevalue) {
    double dropout_tmp = this->nn_parameter->dropout;
    double alpha_tmp = this->nn_parameter->alpha;
    double lr_tmp = this->nn_parameter->lr;
    double weight_decay_tmp = this->nn_parameter->weight_decay;
    if (param_name == "dropout") this->set_nnparameters(singlevalue, alpha_tmp, lr_tmp, weight_decay_tmp);
    else if (param_name == "alpha") this->set_nnparameters(dropout_tmp, singlevalue, lr_tmp, weight_decay_tmp);
    else if (param_name == "lr") this->set_nnparameters(dropout_tmp, alpha_tmp, singlevalue, weight_decay_tmp);
    else if (param_name == "weight_decay") this->set_nnparameters(dropout_tmp, alpha_tmp, lr_tmp, singlevalue);
    else {
        cout << "      User_api:: NN-PARAMETER ERROR - please check the name of the parameter." << endl;
        return;
    }
    cout << "      User_api:: CHANGE NN-PARAMETER! (" << param_name << ")" << endl;
}

template <typename T>
T User_api::get_nnparameter(string param_name) {
    if (param_name == "dropout") return this->nn_parameter->dropout;
    else if (param_name == "alpha") return this->nn_parameter->alpha;
    else if (param_name == "lr") return this->nn_parameter->lr;
    else if (param_name == "weight_decay") return this->nn_parameter->weight_decay;
    else {
        cout << "      User_api:: NN-PARAMETER ERROR - please check the name of the parameter." << endl;
        return T(-1.);
    }
}

int User_api::get_nndata(string param_name) {
    if (param_name == "n_sample") return this->nn_data->n_sample;
    else if (param_name == "n_class") return this->nn_data->n_class;
    else {
        cout << "      User_api:: USER-PARAMETER ERROR - please check the name of the parameter." << endl;
        return -1;
    }
}

double User_api::get_nndata(string param_name, int label, int index) {
    if (param_name == "batch_ans") return this->nn_data->batch_ans[label][index];
    else {
        cout << "      User_api:: USER-PARAMETER ERROR - please check the name of the parameter." << endl;
        return NULL;
    }
}

template <typename T>
PyObject* User_api::call_func(string func_name, int num_args, PyObject* obj, ...) {
    PyObject* func, * pArgs, * pReturn;
    if (func_name == "func_load_dataset") func = this->func_load_dataset;
    else if (func_name == "func_set_nnparameters") func = this->func_set_nnparameters;
    else if (func_name == "func_update_nndata") func = this->func_update_nndata;
    else if (func_name == "func_backpropagation") func = this->func_backpropagation;
    else {
        cout << "      User_api:: PYFUNCTION ERROR - please check the name of the function." << endl;
        return NULL;
    }

    if (func && PyCallable_Check(func)) {
        pArgs = PyTuple_New(num_args);
        va_list arg_list;
        va_start(arg_list, obj);
        T arg = 0;
        for (int i = 0; i < num_args; i++) {
            if (i == 0 && obj != NULL)  PyTuple_SetItem(pArgs, 0, obj);
            else {
                arg = va_arg(arg_list, T);
                PyTuple_SetItem(pArgs, i, PyLong_FromLong(arg));
            }
        }
        pReturn = PyObject_CallObject(func, pArgs);
        Py_DECREF(pArgs);
        if (pReturn == NULL) {
            cout << "      User_api:: PYFUNCTION ERROR - null return." << func_name<<endl;
            return NULL;
        }
        else if (func_name == "func_load_dataset") return pReturn;
        else if (func_name == "func_set_nnparameters") return pReturn;
        else if (func_name == "func_update_nndata") {
            if (!PyList_Check(pReturn)) {
                cout << "      User_api:: PYFUNCTION ERROR - wrong return." << endl;
                Py_DECREF(pReturn);
                return NULL;
            }
            else return pReturn;
        }
        else if (func_name == "func_backpropagation") return pReturn;
        else {
            Py_DECREF(pReturn);
            return NULL;
        }
    }
    else cout << "      User_api:: PYFUNCTION CALL ERROR 1" << endl;
    return NULL;
}

template <typename T>
PyObject* User_api::call_func(string func_name, PyObject* obj, PyObject* objtwo, int mode) {
    PyObject* func, * pArgs, * pReturn;
    if (func_name == "func_update_nndata") func = this->func_update_nndata;
    else {
        cout << "      User_api:: PYFUNCTION ERROR - please check the name of the function." << endl;
        return NULL;
    }

    if (func && PyCallable_Check(func)) {
        pArgs = PyTuple_New(3);
        PyTuple_SetItem(pArgs, 0, obj);
        PyTuple_SetItem(pArgs, 1, objtwo);
        PyTuple_SetItem(pArgs, 2, PyLong_FromLong(mode));
        
        pReturn = PyObject_CallObject(func, pArgs);
        Py_DECREF(pArgs);
        if (pReturn == NULL) {
            cout << "      User_api:: PYFUNCTION ERROR - null return." << endl;
            return NULL;
        }
        else if (func_name == "func_update_nndata") {
            if (!PyList_Check(pReturn)) {
                cout << "      User_api:: PYFUNCTION ERROR - wrong return." << endl;
                Py_DECREF(pReturn);
                return NULL;
            }
            else return pReturn;
        }
        else {
            Py_DECREF(pReturn);
            return NULL;
        }
    }
    else cout << "      User_api:: PYFUNCTION CALL ERROR 1" << endl;
    return NULL;
}


void User_api::load_dataset(int* n_dataset_index) {
    cout << "      User_api:: START DATASET LOADING!" << endl;
    PyObject* list = this->call_func<int>("func_load_dataset", 0, NULL);
    int size = int(PyList_Size(list));     cout << "      User_api:: the number of the return values (expected 1): " << size << endl;
    PyObject* tmp;     tmp = PyList_GetItem(list, 0);
    n_dataset_index[0] = PyLong_AsLong(tmp);
    Py_DECREF(list);
    cout << "      User_api:: COMPLETE DATASET LOADING!" << endl;
}


void User_api::update_nndata_batch(int mode, vector<int> train_sample_index_array, vector<int> internal_test_index_array) {     cout << "      User_api:: START FORWARDING!" << endl;
    PyObject* sample_index_list = PyList_New(0);
    PyObject* internal_test_index_list = PyList_New(0);
    for (int i = 0; i < static_cast<int>(train_sample_index_array.size()); i++) PyList_Append(sample_index_list, PyLong_FromLong(train_sample_index_array[i]));
    for (int i = 0; i < static_cast<int>(internal_test_index_array.size()); i++) PyList_Append(internal_test_index_list, PyLong_FromLong(internal_test_index_array[i]));
    PyObject* return_list = this->call_func<int>("func_update_nndata", internal_test_index_list, sample_index_list, mode);
    Py_DECREF(sample_index_list);
    Py_DECREF(internal_test_index_list);

    int size = int(PyList_Size(return_list));     cout << "      User_api:: the number of the return values (expected 3): " << size << endl;
    PyObject* wholetmp;     PyObject* tmp;     PyObject* tmp2;     PyObject* tmp3;     int nsample = 0;
    int nclass = 0;
    memset(nn_data->ans_sum, 0, sizeof(nn_data->ans_sum));

        cout << "      User_api:: updating parameters..." << endl;
    tmp = PyList_GetItem(return_list, 0);
    size = PyList_Size(tmp);
    
    nclass = PyLong_AsLong(PyList_GetItem(tmp, 0));
    this->nn_data->n_class = nclass;
    nsample = PyLong_AsLong(PyList_GetItem(tmp, 1));
    this->nn_data->n_sample = nsample;
    set_userparameter("n_sample", nsample);
        cout << "      User_api:: updating labels..." << endl;
    wholetmp = PyList_GetItem(return_list, 1);
    for (int l = 0;l < n_label;l++)
    {
        tmp = PyList_GetItem(wholetmp, l);
        size = PyList_Size(tmp);
        for (int j = 0; j < nsample; j++) {
            double item = PyFloat_AsDouble(PyList_GetItem(tmp, j));
            this->nn_data->batch_ans[l][j] = item;
        }
    }
        cout << "      User_api:: updating the output of neural network..." << endl;
    wholetmp = PyList_GetItem(return_list, 2);
    for (int l = 0;l < n_label;l++)
    {
        tmp = PyList_GetItem(wholetmp, l);
        size = PyList_Size(tmp);
        for (int j = 0; j < nsample; j++) {
            tmp3 = PyList_GetItem(tmp, j);
            this->nn_data->batch_expected[l][j] = PyFloat_AsDouble(PyList_GetItem(tmp3, 0));
        }
    }
    Py_DECREF(return_list);
    cout << "      User_api:: COMPLETE FORWARDING!" << endl;
}




void User_api::backpropagation(int mode = 1) {     cout << "      User_api:: START BACKPROPAGATION!" << endl;
    PyObject* nn_gradient_list = PyList_New(0);
    PyObject* tmp = NULL;
    PyObject* tmp2 = NULL;
    int nclass = this->nn_data->n_class;
    int nsample = this->user_parameter->n_sample;


    cout << "      User_api:: preparing gradient list..." << endl;
    int n_internal_test_case = this->user_parameter->n_internal_test_case;
    for (int l = 0;l < n_label;l++)
    {
        tmp = PyList_New(0);
        for (int i = 0; i < nsample; i++) {
            tmp2 = PyList_New(0);
            PyList_Append(tmp2, PyFloat_FromDouble(this->gradient->batch_expected_gradient[l][i]));
            PyList_Append(tmp, tmp2);
            Py_DECREF(tmp2);
        }
        PyList_Append(nn_gradient_list, tmp);
        if (tmp != NULL) Py_DECREF(tmp);
    }
    PyObject* list = this->call_func<int>("func_backpropagation", 2, nn_gradient_list, 2);
    Py_DECREF(nn_gradient_list);
    cout << "      User_api:: COMPLETE BACKPROPAGATION!" << endl;
}